#include <ti/screen.h>
#include <ti/getcsc.h>
#include <ti/flags.h>
#include <stdlib.h>
#include <stdbool.h>

void enable_alpha_lowercase(void) {
    os_ResetFlag(LOWERCASE, ENABLE);
}

void disable_alpha_lowercase(void) {
    os_SetFlag(LOWERCASE, ENABLE);
}

bool is_alpha_lowercase_enabled(void) {
    return !os_TestFlag(LOWERCASE, ENABLE);
}

void toggle_lowercase(bool enabled) {
    if (enabled) {
        enable_alpha_lowercase();
    } else {
        disable_alpha_lowercase();
    }
}

void graphix(bool enabled) {
    os_ClrHome();
    if (enabled) {
        os_PutStrFull("TI-OS Lowercase disabled.");
        os_NewLine();
        os_PutStrFull("Press clear to exit,");
        os_NewLine();
        os_PutStrFull("and 2nd to enable.");
    } else {
        os_PutStrFull("TI-OS Lowercase enabled.");
        os_NewLine();
        os_PutStrFull("Press clear to exit,");
        os_NewLine();
        os_PutStrFull("and 2nd to disable.");
    }
}

int main(void) {
    bool enabled = is_alpha_lowercase_enabled();

    graphix(enabled);

    uint8_t key = 0;

    while (key != sk_Clear) {
        while (!(key = os_GetCSC()));
        if (key == sk_2nd) {
            enabled = !enabled;
            toggle_lowercase(enabled);
            graphix(enabled);
        }
    }

    return 0;
}
