#include <tice.h>
#include <string.h>
#include <graphx.h>
#include <keypadc.h>

#include "common.h"
#include "gui.h"

char input[MAX_EXPR_LEN];
char result[MAX_EXPR_LEN];
TruthTable table;

int cursor_pos = 0;

void insert_char(char c) {
    int len = strlen(input);
    if (len < MAX_EXPR_LEN - 1) {
        memmove(input + cursor_pos + 1, input + cursor_pos, len - cursor_pos + 1);
        input[cursor_pos] = c;
        cursor_pos++;
    }
}

void backspace() {
    if (cursor_pos > 0) {
        int len = strlen(input);
        memmove(input + cursor_pos - 1, input + cursor_pos, len - cursor_pos + 1);
        cursor_pos--;
    }
}

int main(void) {
    gui_init();
    
    input[0] = 0;
    result[0] = 0;
    cursor_pos = 0;
    bool solved = false;  
    bool redraw = true;   

    while(1) {
        if(redraw) {
            draw_dashboard(input, result, solved, table.num_vars, cursor_pos);
            redraw = false;
        }

        uint8_t key = os_GetCSC();
        if(key == 0) continue;

        if (key == sk_Mode) {
            break; 
        }

        if (key == sk_Left) {
            if (cursor_pos > 0) {
                cursor_pos--;
                redraw = true;
            }
        }
        if (key == sk_Right) {
            if (cursor_pos < (int)strlen(input)) {
                cursor_pos++;
                redraw = true;
            }
        }

        if(key == sk_Clear) {
            if (input[0] != '\0') {
                input[0] = '\0'; 
                result[0] = '\0';
                cursor_pos = 0;
                solved = false;
                redraw = true;
            } else {
                break; 
            }
        }

        if(key == sk_Del) {
            if(strlen(input) > 0 && cursor_pos > 0) {
                backspace();
                solved = false; 
                redraw = true;
            }
        }

        if(key == sk_Enter) {
            if(strlen(input) > 0) {
                draw_status("Analyzing expression...", 0);
                parse_expression(input, &table);
                
                simplify_expression(&table, result);
                
                solved = true;
                redraw = true;
            }
        }

        bool is_error = (strncmp(result, "ABORTED", 7) == 0 || strncmp(result, "ERROR", 5) == 0);

        if (solved && !is_error && table.num_vars <= 4) {
            if(key == sk_Trace) { show_kmap_window(&table); redraw = true; }
            if(key == sk_Graph) { show_truthtable_window(&table); redraw = true; }
        } 
        else if (!solved) {
            if(key == sk_Graph) {
                if(strlen(input) > 0) {
                    input[0] = 0;
                    cursor_pos = 0;
                    redraw = true;
                }
            }
        }

        char to_add = 0;
        
        if(key == sk_0)      to_add = '0';
        if(key == sk_1)      to_add = '1';

        if(key == sk_Math)   to_add = 'A';
        if(key == sk_Apps)   to_add = 'B';
        if(key == sk_Prgm)   to_add = 'C';
        if(key == sk_Recip)  to_add = 'D';
        if(key == sk_Sin)    to_add = 'E';
        if(key == sk_Cos)    to_add = 'F';
        if(key == sk_Tan)    to_add = 'G';
        if(key == sk_Power)  to_add = 'H';
        if(key == sk_Square) to_add = 'I';
        if(key == sk_Comma)  to_add = 'J';
        
        if(key == sk_Yequ)   to_add = '+';
        if(key == sk_Window) to_add = '*';
        if(key == sk_Zoom)   to_add = '!'; 
        
        if(key == sk_Add) to_add = '+';
        if(key == sk_Mul) to_add = '*';
        if(key == sk_Sub) to_add = '!';

        if(key == sk_LParen) to_add = '(';
        if(key == sk_RParen) to_add = ')';

        if(to_add != 0) {
            insert_char(to_add); 
            solved = false; 
            redraw = true;
        }
    }

    gui_close();
    return 0;
}