# LOGiCE
**LOGiCE** is a powerful boolean algebra simplifier and analysis tool for the TI-84 Plus CE calculator family. It uses the Quine-McCluskey algorithm to minimize logic expressions with up to **10 variables**.

## Features
* **Minimization:** Simplifies expressions with up to 10 variables (A-J).
* **Visualizations:** 
    * Karnaugh Map 
    * Truth Table
* **Safety:** Handles large expressions by automatically exporting to system variable `Y1` if the output is too long for the screen.
* **Input:** Supports standard notation (`+` for OR, `*` for AND, `!` for NOT).

## Installation
To run LOGiCE, you need a TI-84 Plus CE (or CE-T / Python edition).

1.  **Download:** Grab the latest `LOGiCE.8xp` from [Releases](https://github.com/atomicra1n/LOGiCE/releases/latest).
2.  **C Libraries (Important!):** You **MUST** have the CE C Libraries installed (`clibs.8xg`). If you don't have them, [download them here](https://github.com/CE-Programming/libraries/releases) and send them to your calculator.
3.  **Transfer:** Send `LOGiCE.8xp` (and `clibs.8xg` if needed) to your calculator using TI Connect CE or TiLP.
4.  **Jailbreak (OS 5.5+):** If your calculator runs OS 5.5.1 or newer, you cannot run ASM programs directly. You need to use [arTIfiCE](https://yvantt.github.io/arTIfiCE/) and a shell like **Cesium** to launch the program.

## Controls
| Key | Action |
| :--- | :--- |
| **A - J** | `[Math]`, `[Apps]`, `[Prgm]`, ... (A-J shortcuts) |
| **OR (+)** | `[+]` or `[Y=]` |
| **AND (*)** | `[*]` or `[Window]` |
| **NOT (!)** | `[-]`, `[Zoom]`, or `[Sub]` |
| **ENTER** | Simplify expression |
| **TRACE** | Open K-Map (if vars <= 4) |
| **GRAPH** | Open Truth Table (if vars <= 4) |
| **DEL** | Backspace |
| **CLEAR** | Clear input / Back to Dashboard |
| **2nd + MODE** | Quit Program |

## Compatibility
Tested on **TI-84 Plus CE-T Python Edition**. Should work on any TI-84 Plus CE model.
Please report any issues in the [Issues tab](https://github.com/atomicra1n/LOGiCE/issues).

## Building from Source
If you want to modify the code or build it yourself:

1.  Install the [CE C Toolchain](https://github.com/CE-Programming/toolchain).
2.  Clone this repository.
3.  Run `make` in the root directory.
4.  The output file will be in `bin/LOGiCE.8xp`.

---